#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Sep  5 16:10:21 2023

@author: soumi
"""

""" IMPORTS """
import numpy as np
import matplotlib.pyplot as plt

import cadet_standard_functions as csf

n_comp = 1 
t_cycle = 60    # 1 min = 60 s
Q = 1e-6        # 1 mL/s = 1e-6 m^3/s

model = csf.get_cadet_template(n_units=2)

""" INLET """
model.root.input.model.unit_000.unit_type = 'INLET'
model.root.input.model.unit_000.ncomp = n_comp
model.root.input.model.unit_000.inlet_type = 'PIECEWISE_CUBIC_POLY'

model.root.input.model.unit_000.sec_000.const_coeff = [1.0,] # mM
model.root.input.model.unit_000.sec_000.lin_coeff = [0.0,]
model.root.input.model.unit_000.sec_000.quad_coeff = [0.0,]
model.root.input.model.unit_000.sec_000.cube_coeff = [0.0,]

model.root.input.model.unit_000.sec_001.const_coeff = [0.0,] # mM
model.root.input.model.unit_000.sec_001.lin_coeff = [0.0,]
model.root.input.model.unit_000.sec_001.quad_coeff = [0.0,]
model.root.input.model.unit_000.sec_001.cube_coeff = [0.0,]

""" OUTLET """
model.root.input.model.unit_001.unit_type = 'OUTLET'
model.root.input.model.unit_001.ncomp = 1

""" SOLVER """
model.root.input.solver.sections.nsec = 2
model.root.input.solver.sections.section_times = [0.0, t_cycle/2, t_cycle]   # s
model.root.input.solver.sections.section_continuity = [0]

""" CONNECTIONS """
model.root.input.model.connections.nswitches = 1
model.root.input.model.connections.switch_000.section = 0
model.root.input.model.connections.switch_000.connections = [
    0, 1, -1, -1, Q, # unit_000, unit_001, all components, all components, Q/ m^3/s
]  

model.root.input.solver.user_solution_times = np.linspace(0, t_cycle, 1001)

#csf.run_simulation(model)
data = model.run()

plt.figure()

time = model.root.output.solution.solution_times
c = model.root.output.solution.unit_001.solution_inlet
plt.plot(time/60, c)
plt.xlabel('$time~/~min$')
plt.ylabel('$Outlet~concentration~/~mM$')
plt.show()